<?php
/**
 * TinyGallery - one file gallery script
 * Author: Michael Bertsch (http://michaelbertsch.eu)
 * License: http://creativecommons.org/licenses/by-sa/2.0/de/
**/
error_reporting(E_ALL);

// Config
$conf_imagedir	= '.';   // Directory where to find the images ("." = this dir).
$conf_subdirs	= TRUE;  // Allow users to browse subdirs?
$conf_info      = TRUE;  // Show additional information?
$conf_bttn_show	= TRUE;  // Show Previous/Next buttons?
$conf_bttn_move = FALSE; // Move Previous/Next buttons, so they arn't disturbing in the image?

$validext = array('jpg', 'jpeg', 'png', 'gif', 'bmp'); // Valid image extensions

// Functions
function dirlist($dir, $ignore = array('.', '..')) {
	global $validext, $conf_imagedir;
	
	$images = array();
	$dirs = array();
	$handle = opendir($dir);
		while($file = readdir($handle)) {
			if(!in_array($file, $ignore)) {
				// Check extension. Add mime-type check
				if(in_array(strtolower(ext($file)), $validext)) {
					$images[] = $file;
				}
				// Save when dir
				elseif(is_dir($dir .'/'. $file)) {
				    $dirs[] = ($dir != '.' ? $dir .'/' : '') . $file;
				}
			}
		}
	closedir($handle);
	return array($images, $dirs);
}

// Formats a filesize using bytes count
function format_size($size, $format = '%.2f %s') {
	$i = 0;
	$units = array('Bytes', 'KB', 'MB', 'GB', 'TB', 'PB');

	while($size >= 1024 && $i < 5) {
		$size = $size / 1024;
		$i++;
	}
	return sprintf($format, $size, $units[$i]);
}

// Returns a files extension
function ext($filename) {
	return substr(strrchr($filename, '.'), 1);
}

// Returns different colors (for styling)
function randcol() {
	$cols = array('#66CC33', '#99CC33', '#FF6633', '#CC3300', '#FF0099', '#9900FF', '#0033FF', '#0099FF');
	return $cols[rand(0, count($cols)-1)];
}

// Directory exists?
if(!empty($_GET['d']) && $conf_subdirs && !preg_match('@(^\.|\.$)@', $_GET['d']) && is_dir($_GET['d'])) {
	$dir = urldecode($_GET['d']);
}
else {
	$dir = $conf_imagedir;
}

list($files, $subdirs) = dirlist($dir);

// Get current image
if(!empty($_GET['i']) && is_numeric($_GET['i'])) {
	$img_nr = $_GET['i'];
	$img_key = $img_nr - 1;
}
else {
	$img_nr = 1;
	$img_key = 0;
}

// Image exists?
if(array_key_exists($img_key, $files)) {
	$current = $dir .'/'. $files[$img_key];
	$img_count = count($files);

	// Get sizes
	list($width, $height) = getimagesize($current);

	// Links
	if(array_key_exists($img_key - 1, $files)) {
		$previous = '?i='. ($img_nr - 1) . ($dir != $conf_imagedir ? '&amp;d='. urlencode($dir) : '');
	}
	if(array_key_exists($img_key + 1, $files)) {
		$next = '?i='. ($img_nr + 1) . ($dir != $conf_imagedir ? '&amp;d='. urlencode($dir) : '');
		$preload_img = ($dir != $conf_imagedir ? $dir : '') . $files[$img_key + 1];
	}

	// Calculate coords for image map
	$left_coords  = implode(',', array(0, 0, $width/2, $height));
	$right_coords = implode(',', array($width/2, 0, $width, $height));
	$info_coords  = implode(',', array(0, $height-60, $width, $height));


	// Prepare info area
	if($conf_info) {
		$infos = array(
			'Filename'	=> htmlspecialchars($files[$img_key]),
			'Filesize'  => format_size(filesize($current)),
			'Created'	=> date('j.n.Y H:i', filemtime($current)),
			'Dimensions'=> $width .' x '. $height .' px'
			);

		$info_info = '<ul>';
		foreach($infos as $key => $value) {
	    	$info_info .= '<li><span>'. $key .':</span> '. $value .'</li>';
		}
		$info_info .= '</ul>';
	}
	// Subdir info
	if($conf_subdirs) {
		if(count($subdirs) OR $dir != $conf_imagedir) {
		    $info_subdirs = '<ul>';

			if($dir != $conf_imagedir) {
				// Display back link only when not in root
				$info_subdirs .= '<li><a href="?d='. substr($dir, 0, strrpos($dir, '/')) .'" title="Go back">..</a></li>';
			}
		    $dir_count = 0;
			foreach($subdirs as $subdir) {
			    $info_subdirs .= '<li><a href="?d='. urlencode($subdir) .'">'. htmlspecialchars($subdir) .'</a></li>';
		        $dir_count++;
				if($dir_count >= 10) {
					$info_subdirs .= '<li>...</li>';
					break;
				}
			}
			$info_subdirs .= '</ul>';
		}
	}
}
else {
	// Empty dir
	$height = 100;
	$width = 500;
	$info_coords = '0,0,0,0';
	$error = '<h2>Sorry pal, no images in here.</h2><p><a href="'. $_SERVER['PHP_SELF'] .'" style="text-decoration:underline">back to root</a></p>';
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="de" xml:lang="de">
<head>
<!--
	This Gallery is powered by TinyGallery.
	Author: Michael Bertsch (http://michaelbertsch.eu)
	License: http://creativecommons.org/licenses/by-sa/2.0/de/
-->
<title> </title>
<script type="text/javascript">
var TinyGallery = {
	initialize: function() {
		// Enable info area when js enabled.
		document.getElementById('area_info').coords = '<?php echo $info_coords ?>';
	},
	setDisp: function(element, value) {
		var el = document.getElementById(element);
		if(el.style.display != value) {
			el.style.display = value;
		}
	},
	toggleDisp: function(element) {
		var el = document.getElementById(element);
		if(el.style.display == 'block') {
		    el.style.display = 'none';
		}
		else {
			el.style.display = 'block';
		}
	}
}
</script>
<style type="text/css">
body {
	background: #eee;
	text-align: center;
	font-family: Arial, Verdana, sans-serif;
	font-size: 0.8em;
}
a:link,
a:visited,
a:active {
	color: #000;
	text-decoration: none;
}
a:hover {
	color: <?php echo randcol() ?>;
}
img#image {
	border: none;
	z-index: 1;
}
img.preload {
	visibility: hidden;
	width: 0;
	height: 0;
}
div#imgbox {
	position: relative;
	background: #fff;
	height: <?php echo $height ?>px;
	width: <?php echo $width ?>px;
	border: 1px #ddd solid;
	padding: 10px;
	margin: auto;
	<?php if($conf_bttn_move) echo 'padding-top: 26px;'; ?>
}


div#previous a,
div#next a {
	display: block;
	background: #fff;
	font-weight: bold;
	padding: 5px 15px;
}
div#previous {
	position: absolute;
	left: 10px;
	top: 0%;
	z-index: 10;
}
div#next {
	position: absolute;
	right: 0;
	top: 0%;
	z-index: 10;
	margin-right: 10px;
}


div#info {
	position: absolute;
	left: 10px;
	bottom: 10px;
	z-index: 5;
	background: #fff;
	width: <?php echo $width ?>px;
	text-align: left;
	filter: alpha(opacity=85);
	-moz-opacity: 0.85;
	display: none;
}
div#info h2 {
	margin: 0;
	padding: 2px 5px;
	font-size: 1.1em;
	color: red;

}
div#info div {
	display: none;
}
div#info ul {
	margin: 0;
	padding: 5px 10px;
	list-style-type: none;
	line-height: 18px;
}
div#info span {
	font-weight: bold;
	display: block;
	width: 7em;
	float: left;
}
div#info #imgcount {
	float: right;
	margin: 5px;
	border: none;
	display: block;
}
div#info #imgdirs ul {
	list-style-type: decimal;
	margin: 0 0 0 25px;
}
</style>
</head>

<head>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1256">
<meta http-equiv="Content-Language" content="ar-sa">
<title> </title>
</head>

<body onload="TinyGallery.initialize();">
	<map name="imgmap">
 	<area shape="rect" id="area_info" coords="0,0,0,0" href="#" onmouseover="TinyGallery.setDisp('info', 'block');" onmouseout="TinyGallery.setDisp('info', 'none');" />
		<?php if(isset($previous)) { ?>
			<area shape="rect" coords="<?php echo $left_coords ?>" href="<?php echo $previous ?>" onmouseover="TinyGallery.setDisp('previous', 'block');" onmouseout="TinyGallery.setDisp('previous', 'none');" />
		<?php } if(isset($next)) { ?>
			<area shape="rect" coords="<?php echo $right_coords ?>" href="<?php echo $next ?>" onmouseover="TinyGallery.setDisp('next', 'block');" onmouseout="TinyGallery.setDisp('next', 'none');" />
		<?php } ?>
	</map>
	<div id="imgbox">
		<?php if(isset($current)) { ?>
			<img id="image" src="<?php echo htmlspecialchars($current) ?>" alt="Bild: <?php echo htmlspecialchars($current) ?>" usemap="#imgmap" />
				<?php if($conf_bttn_show) { ?>
					<?php if(isset($previous)) { ?><div id="previous"><a href="<?php echo $previous ?>" onmouseover="TinyGallery.setDisp('previous', 'block');" onmouseout="TinyGallery.setDisp('previous', 'none');">
			 </a></div><?php } ?>
					<?php if(isset($next)) { ?><div id="next"><a href="<?php echo $next ?>" onmouseover="TinyGallery.setDisp('next', 'block');" onmouseout="TinyGallery.setDisp('next', 'none');">
			 </a></div><?php } ?>
				<?php } ?>
			<div id="info" onmouseover="TinyGallery.setDisp('info', 'block');" onmouseout="TinyGallery.setDisp('info', 'none');">
				<div id="imgcount">Image <?php echo $img_nr ?> of <?php echo $img_count ?></div>
				<?php if(isset($info_info)) { ?><h2><a href="#" onclick="TinyGallery.toggleDisp('imginfo')">
				Image Info</a></h2><div id="imginfo" style="display:block"><?php echo $info_info ?></div><?php } ?>
				<?php if(isset($info_subdirs)) { ?><h2><a href="#" onclick="TinyGallery.toggleDisp('imgdirs')">
				Browse Subfolders</a></h2><div id="imgdirs"><?php echo $info_subdirs ?></div><?php } ?>
			</div>
			<div style="clear: both;"></div>
		<?php } elseif(isset($error)) { echo $error; } ?>
	</div>
	<?php if(isset($preload_img)) { ?><img class="preload" src="<?php echo $preload_img ?>" alt="&nbsp;" /><?php } ?>
<table border="1" width="81%">
	<tr>
		<td width="405" align="center">
		<p dir="rtl">&nbsp;     </td>
		<td width="210" align="center">
		<p dir="rtl">&nbsp; </td>
	</tr>
	<tr>
		<td width="405" align="center">
		<p dir="rtl"> </td>
		<td width="210" align="center">
		<p dir="rtl">&nbsp;</td>
	</tr>
	<tr>
		<td width="405" height="26" align="center">
		<p dir="rtl">1211</td>
		<td width="210" height="26" align="center">
		<p dir="rtl"> </td>
	</tr>
	<tr>
		<td width="405" height="24" align="center">
		<p dir="rtl">57</td>
		<td width="210" height="24" align="center">
		<p dir="rtl"> </td>
	</tr>
	<tr>
		<td width="405" align="center">
		<p dir="rtl">2417</td>
		<td width="210" align="center">
		<p dir="rtl">&nbsp;</td>
	</tr>
	<tr>
		<td width="405" align="center">
		<p dir="rtl"><span lang="en-us">
		<a href="http://www.ma56o6at.com/zip/063.zip">
		http://www.ma56o6at.com/zip/063.zip </a></span></td>
		<td width="210" align="center">
		<p dir="rtl">   ( )</td>
	</tr>
</table>
</body>
</html>